// -------------  Fontion DoubleToString  ------------------------
// Renvoie un réel au format chaine avec le nombre de décimales égale 
// à la variable précision   
// val : double (réel) à convertir
// precision : nombre de 0 à 6 indiquant le nombre de décimal voulue
//
// exemple: DoubleToString( 3.1415, 2); // renvoie "3.14" (précision à 2 décimales)
//-----------------------------------------------------------------

String DoubleToString( double val, byte precision){
 
  unsigned long frac;
  unsigned long mult = 1;
  byte padding = precision -1;
  String sVal="" ;
  
  //Récupère la partie entière
  sVal.concat(int(val));
  
  //Si précision demandée > 0 décimale
  if( precision > 0) {sVal.concat(".");    //Ajoute la virgule
      
    //Tantque Precision est supérieur à 0
    while(precision--){mult *=10;}  //Calcul du multiple
    
    //Si val >=0 alors 
    if(val >= 0){
      frac = (val - int(val)) * mult;} //calcul de la fraction positive
    else{
      frac = (int(val)- val ) * mult;}// calcul de la fraction négative
    unsigned long frac1 = frac;
    while(frac1 /= 10){padding--;}  
    while(padding--){sVal.concat("0");}  //Ajoute des 0
    
    //Ajoute la partie décimale
    sVal.concat(frac);
    
   }
   
   return sVal;
  
}
